#ifndef __MAP_H
#define __MAP_H

inline int map(int x, int a, int b, int c, int d) {
    // Transform an integer value x between bounds a and b into a 
    // corresponding integer value between bounds c and d.
    return static_cast<int>(((x-a)/(float)(b-a) * (d-c)) + c);
}

inline int map(double x, double a, double b, int c, int d) {
    // Transform a double value x between bounds a and b into a 
    // corresponding integer value between bounds c and d.
    return static_cast<int>(((x-a)/(b-a) * (d-c)) + 0.5) + c;
}

#endif

